/*
    plib.c

    Marc Wolfgram
    15 July 89

    1.0 ualloc, urealloc and ufree (originally internal GENESYS functions)
    1.1 ualloc memory attribute was 8018, added locked bit.
    1.2 ualloc now has long size and accepts attributes word as 3rd arg
 */

#pragma optimize -1

#pragma keep "umemory"
#pragma memorymodel 0

#include <memory.h>

long ualloc(long, int, int);
long urealloc(long, int);
void ufree(long);
int  toolerror(void);

long ualloc(long size, int eserid, int attr)
{
    long *hand;
    hand = (long *) NewHandle(size, userid, attr, (long) 0);
    if (toolerror())
        return 0L;
    return *hand;
}

long urealloc(long pntr, int size)
{
    long *hand;
    hand = (long *) FindHandle(pntr);
    if (hand) {
        HUnlock(hand);
        SetHandleSize((long) size, hand);
        if (!toolerror()) { 
            HLock(hand);
            return *hand;
        }
    }
    return 0;
}

void ufree(long pntr)
{
    DisposeHandle((long) FindHandle(pntr));
}